/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.superplan;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cz.insophy.inplan.plan.Plan;
import cz.insophy.inplan.shop.Action;
import cz.insophy.inplan.shop.Bom;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.shop.MaterialQuantity;
import cz.insophy.inplan.shop.RebuildType;
import cz.insophy.inplan.shop.Workplace;
import cz.insophy.inplan.store.ExternalStoreActivity;
import cz.insophy.inplan.store.StoreSchedule;
import cz.insophy.inplan.store.StoreType;
import cz.insophy.inplan.superplan.GeneralizedActionRequest;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import cz.insophy.inplan.superplan.GeneralizedRequest;
import cz.insophy.inplan.superplan.Superplan;
import cz.insophy.inplan.util.Tuple;
import cz.insophy.inplan.util.problems.Problem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StarvingGors {
    private static final Logger log = LoggerFactory.getLogger(StarvingGors.class);
    private final boolean findToolStarving;
    private final boolean addMissingTools;
    private final boolean findMatStarving;
    private final boolean addMissingMats;
    private final Superplan superplan;
    private final Map<Material, Double> requested;
    private final LoadingCache<Material, Double> available;

    private StarvingGors(Superplan superplan, ToolStarving toolStarving, MaterialStarving materialStarving) {
        this.superplan = superplan;
        this.findToolStarving = toolStarving.findToolStarving;
        this.addMissingTools = toolStarving.addMissingTools;
        this.findMatStarving = materialStarving.findMatStarving;
        this.addMissingMats = materialStarving.addMissingMats;
        final StoreSchedule ss = superplan.getPlan().getStoreSchedule(StoreType.ACTUAL_ESTIMATE_VIEW);
        this.requested = Maps.newIdentityHashMap();
        this.available = CacheBuilder.newBuilder().build(new CacheLoader<Material, Double>(){

            @Override
            public Double load(@Nonnull Material mat) throws Exception {
                return ss.getQ(mat, Long.MAX_VALUE, false);
            }
        });
    }

    private static Iterable<Tuple<Action, Double>> getActions(GeneralizedOrderRequest gor) {
        ArrayList<Tuple<Action, Double>> res = Lists.newArrayList();
        if (gor.hasSelectedActiongram()) {
            for (GeneralizedActionRequest gar : gor.getGars()) {
                res.add(Tuple.create(gar.getAction(), gar.getAmount()));
            }
        } else {
            for (Action a : gor.getProduct().getDefaultActiongram().getActions()) {
                res.add(Tuple.create(a, a.computeRequestedQty(gor.getAmount())));
            }
        }
        return res;
    }

    public static List<Problem> fixTools(Superplan superplan) {
        StarvingGors sg = new StarvingGors(superplan, ToolStarving.SELECT_ADD_MISSING, MaterialStarving.DO_NOTHING);
        sg.find();
        return sg.fix();
    }

    public static List<Problem> find(Superplan superplan, ToolStarving toolStarving, MaterialStarving materialStarving) {
        StarvingGors sg = new StarvingGors(superplan, toolStarving, materialStarving);
        sg.find();
        return sg.fix();
    }

    private void find() {
        log.debug("Looking for GORs starving for tools({}) or materials({})...", (Object)this.findToolStarving, (Object)this.findMatStarving);
        for (GeneralizedOrderRequest gor : this.superplan.getGors()) {
            boolean select = false;
            for (Tuple<Action, Double> aq : StarvingGors.getActions(gor)) {
                Action a = aq.getFirst();
                double q = aq.getSecond();
                for (Workplace wp : this.superplan.getShopConf().getWorkplaces(a.getCapabilityReq())) {
                    RebuildType rt = wp.getRebuildType(a.getRebuildType());
                    this.processBom(1.0, rt.getBom());
                }
                select |= this.processBom(q, a.getBom());
            }
            if (!select) continue;
            gor.setUserSelected(true);
        }
    }

    private boolean processBom(double q, Bom bom) {
        boolean res = false;
        for (MaterialQuantity mq : bom) {
            Material mat = mq.getMaterial();
            if (!mat.getClass().equals(Material.class)) continue;
            double reqQ = mq.getQty() * (mat.isConstant() ? 1.0 : q);
            double availQ = this.available.getUnchecked(mat);
            Double miss = this.requested.get(mat);
            if (mat.isConsumed()) {
                if (miss == null) {
                    this.requested.put(mat, reqQ);
                } else {
                    this.requested.put(mat, reqQ + miss);
                }
            }
            if (availQ < reqQ && !mat.isConsumed()) {
                if (miss == null) {
                    this.requested.put(mat, reqQ);
                } else {
                    this.requested.put(mat, Math.max(miss, reqQ));
                }
            }
            res |= availQ < reqQ && (this.findMatStarving && mat.isConsumed() || this.findToolStarving && !mat.isConsumed());
        }
        return res;
    }

    private List<Problem> fix() {
        ArrayList<Problem> res = Lists.newArrayList();
        Plan plan = this.superplan.getPlan();
        long time = this.superplan.getFixationDate();
        if (!GeneralizedRequest.isDateValid(time)) {
            time = System.currentTimeMillis();
        }
        for (Map.Entry<Material, Double> mq : this.requested.entrySet()) {
            double availQ;
            Material mat = mq.getKey();
            double reqQ = mq.getValue();
            double missQ = reqQ - (availQ = this.available.getUnchecked(mat).doubleValue());
            if (!(missQ > 1.0E-7)) continue;
            if (this.findMatStarving && mat.isConsumed() || this.findToolStarving && !mat.isConsumed()) {
                log.info("Missing {} of {}.", (Object)missQ, (Object)mat);
            }
            if ((!this.addMissingMats || !mat.isConsumed()) && (!this.addMissingTools || mat.isConsumed())) continue;
            plan.addActivity(new ExternalStoreActivity(time, mat, missQ));
            res.add(Problem.createProblem("34000", "material", mat.getName(), false, mat.getName(), missQ));
        }
        return res;
    }

    public static enum ToolStarving {
        DO_NOTHING(false, false),
        SELECT(true, false),
        SELECT_ADD_MISSING(true, true);

        private final boolean findToolStarving;
        private final boolean addMissingTools;

        private ToolStarving(boolean findToolStarving, boolean addMissingTools) {
            this.findToolStarving = findToolStarving;
            this.addMissingTools = addMissingTools;
        }
    }

    public static enum MaterialStarving {
        DO_NOTHING(false, false),
        SELECT(true, false),
        SELECT_ADD_MISSING(true, true);

        private final boolean findMatStarving;
        private final boolean addMissingMats;

        private MaterialStarving(boolean findMatStarving, boolean addMissingMats) {
            this.findMatStarving = findMatStarving;
            this.addMissingMats = addMissingMats;
        }
    }
}

